/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pse.assessment.AssessmentObject;
import pse.assessment.ConsistencyChecker;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public abstract class SmvComparator
extends AssessmentObject {
    protected int value;

    public abstract boolean matches(int var1);

    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
    }

    public boolean hasText() {
        return true;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    protected void addText(XmlWriter xmlWriter) {
        xmlWriter.addText(String.valueOf(this.value));
    }

    protected void readText(Node node) {
        this.value = Integer.parseInt(XmlUtils.getTransitiveText(node).trim());
    }

    public static SmvComparator createFromElement(Element element) {
        SmvComparator smvComparator = null;
        String string = element.getTagName();
        if (string.equals("vareq")) {
            smvComparator = new Equals();
        } else if (string.equals("vargte")) {
            smvComparator = new GreaterThanOrEquals();
        } else if (string.equals("vargt")) {
            smvComparator = new GreaterThan();
        } else if (string.equals("varlte")) {
            smvComparator = new LessThanOrEquals();
        } else if (string.equals("varlt")) {
            smvComparator = new LessThan();
        } else {
            throw new Error("Unrecognized tag name for SmvComparator: <" + string + ">");
        }
        smvComparator.fromMyNode(element);
        return smvComparator;
    }

    public static class LessThanOrEquals
    extends SmvComparator {
        public boolean matches(int n) {
            return n <= this.value;
        }

        public String getElementName() {
            return "varlte";
        }
    }

    public static class LessThan
    extends SmvComparator {
        public boolean matches(int n) {
            return n < this.value;
        }

        public String getElementName() {
            return "varlt";
        }
    }

    public static class GreaterThanOrEquals
    extends SmvComparator {
        public boolean matches(int n) {
            return n >= this.value;
        }

        public String getElementName() {
            return "vargte";
        }
    }

    public static class GreaterThan
    extends SmvComparator {
        public boolean matches(int n) {
            return n > this.value;
        }

        public String getElementName() {
            return "vargt";
        }
    }

    public static class Equals
    extends SmvComparator {
        public boolean matches(int n) {
            return n == this.value;
        }

        public String getElementName() {
            return "vareq";
        }
    }
}

